/* === Mini-jeu de Rythme Basique pour RPG Maker MZ === */

// Configuration
const RhythmGame = {
    notes: ["a", "s", "d", "f"], // Touche à appuyer
    maxNotes: 10, // Nombre total de notes
    timeLimit: 60, // Temps limite pour appuyer sur une touche (en frames)
    successSound: "Decision1", // Son de réussite
    failSound: "Buzzer1", // Son d'échec
};

// Variables internes
let rhythmGameData = {
    currentNote: null, // La touche actuelle
    remainingNotes: RhythmGame.maxNotes,
    score: 0,
    isActive: false, // Indique si le jeu est en cours
};

// Démarrer le mini-jeu
function startRhythmGame() {
    if (rhythmGameData.isActive) return; // Empêche de lancer plusieurs fois
    rhythmGameData.isActive = true;
    rhythmGameData.remainingNotes = RhythmGame.maxNotes;
    rhythmGameData.score = 0;

    $gameMessage.add("Mini-jeu de rythme démarré !");
    nextNote();
}

// Passer à la note suivante
function nextNote() {
    if (rhythmGameData.remainingNotes <= 0) {
        endRhythmGame();
        return;
    }

    // Choisir une touche aléatoire
    rhythmGameData.currentNote = RhythmGame.notes[Math.floor(Math.random() * RhythmGame.notes.length)];
    $gameMessage.add(`Appuyez sur : ${rhythmGameData.currentNote.toUpperCase()}`);

    // Attendre l'entrée du joueur
    let framesElapsed = 0;
    const interval = setInterval(() => {
        framesElapsed++;

        // Si la touche correcte est appuyée
        if (Input.isTriggered(rhythmGameData.currentNote)) {
            $gameMessage.add("Bravo !");
            rhythmGameData.score++;
            AudioManager.playSe({ name: RhythmGame.successSound, volume: 90, pitch: 100 });
            clearInterval(interval);
            rhythmGameData.remainingNotes--;
            nextNote();
        }

        // Si le temps est écoulé
        if (framesElapsed >= RhythmGame.timeLimit) {
            $gameMessage.add("Raté !");
            AudioManager.playSe({ name: RhythmGame.failSound, volume: 90, pitch: 100 });
            clearInterval(interval);
            rhythmGameData.remainingNotes--;
            nextNote();
        }
    }, 16); // Exécuter environ toutes les 16ms (~1 frame)
}

// Terminer le mini-jeu
function endRhythmGame() {
    rhythmGameData.isActive = false;
    $gameMessage.add(`Mini-jeu terminé ! Score final : ${rhythmGameData.score}/${RhythmGame.maxNotes}`);
}